#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <signal.h>
#include <arpa/telnet.h>
#include <stdlib.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <libeamon.h>

#include "a.h"
#include "ParserIO.h"
#include "Parser.h"
#include "THREAD.h"
#include "eol.h"


#define PRINT(x) \
	if (write_text(x) == -1) \
	{ \
		return -1; \
	}

#define INPUT(x) \
	n = 200; \
	if (read_text(x, &n) == -1) \
	{ \
		perror("read() failed"); \
		return -1; \
	}


THREAD::THREAD()
:next(NULL)
,running(0)
,socket(0)
,ib(0),it(0),iq(0)
,ob(0),ot(0),oq(0)
,account(NULL)
,current_event(NULL)
,selected(NULL)
,prompt_shown(0)
,adjust_case(0)
{
	*last_print = 0;
	*prompt = 0;
	*instr = 0;

	pthread_mutex_lock(&event_mutex);

	current_event = eventbase;
	while (current_event -> next)
		current_event = current_event -> next;

	pthread_mutex_unlock(&event_mutex);
}


THREAD::~THREAD()
{
}


int THREAD::ioloop(char *s,int *l)
{
	struct timeval tv;
	fd_set rfds;
	fd_set wfds;
	int n;
	int max_l = *l;
	char c;
	char buffer[1024];

	*l = 0;
	while (1)
	{
		if (oq)
		{
printf(" - writing %d bytes from output buffer\n",oq);
			if (ob + oq > OUTBUFSIZE)
			{
				int l = OUTBUFSIZE - ob;
				n = write(socket, outbuf + ob, l);
			}
			else
			{
				n = write(socket, outbuf + ob, oq);
			}
printf(" -- %d bytes written\n",n);
			if (n == -1)
			{
				perror("ioloop() write() failed");
//				return -1;
			}
			else
			if (!n)
			{
				cmdline.m_next_line = NULL;
				return 0;
			}
			else
			{
				ob += n;
				if (ob >= OUTBUFSIZE)
					ob -= OUTBUFSIZE;
				oq -= n;
			}
		}

		if (iq)
		{
			c = inbuf[ib++];
			if (ib >= INBUFSIZE)
				ib -= INBUFSIZE;
			iq--;
			if (c == 13 || c == 10)
			{
				if (iq && (inbuf[ib] == 13 || inbuf[ib] == 10))
				{
					ib++;
					if (ib >= INBUFSIZE)
						ib -= INBUFSIZE;
					iq--;
				}
				if (*l < max_l)
					s[*l] = '\n';
				*l = *l + 1;
				return *l;
			}
			else
			{
				if (adjust_case)
					if (c >= 'a' && c <= 'z')
						c -= 32;
				if (*l < max_l)
					s[*l] = c;
				*l = *l + 1;
				if (*l >= max_l)
				{
					while (iq && (inbuf[ib] == 13 || inbuf[ib] == 10))
					{
						ib++;
						if (ib >= INBUFSIZE)
							ib -= INBUFSIZE;
						iq--;
					}
					return *l;
				}
			}
		}

		FD_ZERO(&rfds);
		FD_ZERO(&wfds);
		FD_SET(socket, &rfds);
		FD_SET(socket, &wfds);
		tv.tv_sec = 1;
		tv.tv_usec = 0;
		n = select(socket + 1,&rfds,&wfds,NULL,&tv);
		if (n == -1)
		{
			perror("ioloop() select() failed");
			cmdline.m_next_line = NULL;
			return -1;
		}
		if (!n)
		{
			return 0;	// timeout
		}
		else
		{
			if (FD_ISSET(socket, &rfds))
			{
				n = read(socket, buffer, 1024);
				if (n == -1)
				{
					perror("ioloop() read() failed");
					cmdline.m_next_line = NULL;
					return -1;
				}
				if (!n)
				{
					cmdline.m_next_line = NULL;
					return 0;
				}
				else
				{
					if (it + n > INBUFSIZE)
					{
						int l = INBUFSIZE - it;
						memmove(inbuf + it,buffer,l);
						memmove(inbuf,buffer + l,n - l);
					}
					else
					{
						memmove(inbuf + it,buffer,n);
					}
					it += n;
					if (it >= INBUFSIZE)
						it -= INBUFSIZE;
					iq += n;
				}
			}
			if (FD_ISSET(socket, &wfds) && oq)
			{
				if (ob + oq > OUTBUFSIZE)
				{
					int l = OUTBUFSIZE - ob;
					n = write(socket, outbuf + ob, l);
				}
				else
				{
					n = write(socket, outbuf + ob, oq);
				}
				if (n == -1)
				{
					perror("ioloop() write() failed");
//					return -1;
				}
				else
				if (!n)
				{
					cmdline.m_next_line = NULL;
					return 0;
				}
				else
				{
					ob += n;
					if (ob >= OUTBUFSIZE)
						ob -= OUTBUFSIZE;
					oq -= n;
				}
			}
		}
	} // while (1)
}

#define USE_NEW
#ifdef USE_NEW
int THREAD::read_text(char *s,int *l)
{
	FILE *fil;
	int n = 0;
	int i;
	int max_l = *l;
	int x;
	int crlf = 0;
	int iol;
	char slask[1024];

	if (strstr(last_print,"INSERT DISKETTE WITH ADVENTURE (OR KEEP") &&
	    strstr(last_print,"THIS DISKETTE FOR BEGINNERS CAVE) IN") &&
	    strstr(last_print,"DISK DRIVE IN SLOT SIX, DRIVE ONE THEN") &&
	    strstr(last_print,"HIT 'C'"))
	{
printf(" *** CHANGE DIR TO SELECTED ADVENTURE\n");
		if (selected)
		{
			sprintf(slask,"../%s",selected -> dir);
			if (chdir(slask) == -1)
			{
				perror("chdir() failed");
			}
		}
		strcpy(s,"C");
		*l = 1;
		return 1;
	}

	x = -1;
	for (i = 0; i < (int)strlen(last_print); i++)
		if (last_print[i] == 13 || last_print[i] == 10)
			x = i;
	strcpy(prompt, (x > -1) ? last_print + x + 1 : last_print);
	prompt_shown = 1;

	*l = 0;
	*instr = 0;

	while (1)
	{
		// show events
		if (catchup() == -1)
			return -1;

		if (!prompt_shown)
		{
			PRINT( prompt );
			PRINT( instr );
			prompt_shown = 1;
		}

		iol = max_l;
		n = ioloop(slask, &iol);
printf(" - ioloop() returns %d\n",n);
		if (n == -1)
		{
			perror("read() failed");
			cmdline.m_next_line = NULL;
			return -1;
		}
		else
		if (n == 0)
		{
			cmdline.m_next_line = NULL;
			return 0;
		}
		else
		{
			for (i = 0; i < n; i++)
			{
				if (*l < max_l) // check buffer overflow
				{
					instr[*l] = slask[i];
					s[*l] = slask[i];
				}
				if (slask[i] == 13 || slask[i] == 10)
					crlf = 1;
				*l = *l + 1;
			}
			instr[*l] = s[*l] = 0;

			if (crlf || *l >= max_l)
			{
				n = *l;
				s[*l] = 0;
				while (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10)
					s[strlen(s) - 1] = 0;
				switch (*s)
				{
				case '#':
					fil = fopen("/home/eamon/ends.txt","at");
					if (!fil)
						fil = fopen("/home/eamon/ends.txt","wt");
					fprintf(fil,"%s\n\n",last_print);
					fclose(fil);
					PRINT("Ok.\n");
					break;
				case '"':
				case '\'':
					sprintf(slask,"%s says '%s'.",account -> login,s + 1);
					add_event( slask );
					PRINT("Ok.\n");
					break;
				case '/':
					if (!strcasecmp(s, "/abort"))
					{
						PRINT("Aborting program, press enter.\n");
						cmdline.m_next_line = NULL;
					}
					else
					if (!strncasecmp(s, "/e", 2)) // emote
					{
						x = -1;
						for (i = 0; i < (int)strlen(s); i++)
							if (s[i] == ' ')
							{
								x = i;
								break;
							}
						if (x > -1)
						{
							sprintf(slask,"%s %s\n",account -> login,s + x + 1);
							add_event(slask);
							PRINT( slask );
						}
					}
					else
					if (!strncasecmp(s, "/w", 2))
					{
						THREAD *t;
						VARIABLE *v;
						pthread_mutex_lock(&thread_mutex);
						for (t = threadbase; t; t = t -> next)
						if (t -> account) //login)
						{
							PRINT(t -> account -> login);
							v = t -> cmdline.get_variable("NA$");
							if (v)
							{
								PRINT("  ");
								PRINT(v -> svalue);
							}
							v = t -> cmdline.get_variable("RO");
							if (v)
							{
								PRINT("  Room#");
								sprintf(slask,"%d",(int)v -> value);
								PRINT( slask );
							}
							PRINT("\n");
						}
						pthread_mutex_unlock(&thread_mutex);
					}
					break;
				default:
					// convert to eamon standard uppercase
					if (adjust_case)
					{
						for (i = 0; i < (int)strlen(s); i++)
							if (s[i] >= 'a' && s[i] <= 'z')
								s[i] -= 32;
					}
					return n;
				}
			} // if (crlf)
			if (crlf)
			{
				prompt_shown = 0;
				*l = 0;
				crlf = 0;
				*instr = 0;
			}
		}
	} // while (1)
	return -1;
}

int THREAD::write_text(char *s,int ll)
{
	int l = (ll == -1) ? strlen(s) : ll;
	int i;
	int cr = 0;
	int uc = 1;
	char c;

	strncpy(last_print, s, l);
	last_print[l] = 0;

	for (i = 0; i < l; i++)
	{
		if (s[i] == '\n')
		{
			if (!cr)
			{
outbuf[ot++] = '\r';
if (ot > OUTBUFSIZE)
	ot -= OUTBUFSIZE;
oq++;
outbuf[ot++] = '\n';
if (ot > OUTBUFSIZE)
	ot -= OUTBUFSIZE;
oq++;
				cr = 1;
			}
			else
			{
				cr = 0;
			}
		}
		else
		{
			c = s[i];
			if (adjust_case)
			{
			switch (c)
			{
			case '.':
//			case '\'':
			case '"':
			case '!':
			case ':':
			case '?':
			case '-':
			case '=':
			case '(':
			case ')':
				uc = 1;
				break;
			}
			if (s[i] >= 'A' && s[i] <= 'Z')
			{
				if (!uc)
					c += 32;
				uc = 0;
			}
			} // if (adjust_case)
outbuf[ot++] = c;
if (ot > OUTBUFSIZE)
	ot -= OUTBUFSIZE;
oq++;
			cr = 0;
		}
	}
	return l;
}

#else
int THREAD::read_text(char *s,int *l)
{
	FILE *fil;
	struct timeval tv;
	fd_set rfds;
	int n;
	int i;
	int max_l = *l;
	int x;
	int crlf = 0;
	char slask[1024];

	if (strstr(last_print,"INSERT DISKETTE WITH ADVENTURE (OR KEEP") &&
	    strstr(last_print,"THIS DISKETTE FOR BEGINNERS CAVE) IN") &&
	    strstr(last_print,"DISK DRIVE IN SLOT SIX, DRIVE ONE THEN") &&
	    strstr(last_print,"HIT 'C'"))
	{
printf(" *** CHANGE DIR TO SELECTED ADVENTURE\n");
		if (selected)
		{
			sprintf(slask,"../%s",selected -> dir);
			if (chdir(slask) == -1)
			{
				perror("chdir() failed");
			}
		}
		strcpy(s,"C");
		*l = 1;
		return 1;
	}

	x = -1;
	for (i = 0; i < (int)strlen(last_print); i++)
		if (last_print[i] == 13 || last_print[i] == 10)
			x = i;
	strcpy(prompt, (x > -1) ? last_print + x + 1 : last_print);
	prompt_shown = 1;

	*l = 0;
	*instr = 0;

	while (1)
	{
	// show events
	if (catchup() == -1)
		return -1;

	if (!prompt_shown)
	{
		PRINT( prompt );
		PRINT( instr );
		prompt_shown = 1;
	}

	FD_ZERO(&rfds);
	FD_SET(socket, &rfds);
	tv.tv_sec = 1;
	tv.tv_usec = 0;
	n = select(socket + 1, &rfds, NULL, NULL, &tv);
	if (n == -1)
	{
		perror("select() failed");
		cmdline.m_next_line = NULL;
		return -1;
	}
	else
	if (!n)		// timeout
	{
/*
		printf("select() returns 0 (?)\n");
		cmdline.m_next_line = NULL;
		return 0;
*/
	}
	else
	if (n > 0)
	{
	if (FD_ISSET(socket, &rfds))
	{
		n = read(socket, slask, max_l);
		if (n == -1)
		{
			perror("read() failed");
			cmdline.m_next_line = NULL;
			return -1;
		}
		else
		if (n == 0)
		{
			cmdline.m_next_line = NULL;
			return 0;
		}
		else
		{
			for (i = 0; i < n; i++)
			{
				if (*l < max_l) // check buffer overflow
				{
					instr[*l] = slask[i];
					s[*l] = slask[i];
				}
				if (slask[i] == 13 || slask[i] == 10)
					crlf = 1;
				*l = *l + 1;
			}
			instr[*l] = s[*l] = 0;

			if (crlf || *l >= max_l)
			{
				n = *l;
				s[*l] = 0;
				while (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10)
					s[strlen(s) - 1] = 0;
				switch (*s)
				{
				case '#':
					fil = fopen("/home/eamon/ends.txt","at");
					if (!fil)
						fil = fopen("/home/eamon/ends.txt","wt");
					fprintf(fil,"%s\n\n",last_print);
					fclose(fil);
					PRINT("Ok.\n");
					break;
				case '"':
				case '\'':
					sprintf(slask,"%s says '%s'.",account -> login,s + 1);
					add_event( slask );
					PRINT("Ok.\n");
					break;
				case '/':
					if (!strcasecmp(s, "/abort"))
					{
						PRINT("Aborting program.\n");
						cmdline.m_next_line = NULL;
					}
					else
					if (!strncasecmp(s, "/e", 2)) // emote
					{
						x = -1;
						for (i = 0; i < (int)strlen(s); i++)
							if (s[i] == ' ')
							{
								x = i;
								break;
							}
						if (x > -1)
						{
							sprintf(slask,"%s %s\n",account -> login,s + x + 1);
							add_event(slask);
							PRINT( slask );
						}
					}
					else
					if (!strncasecmp(s, "/w", 2))
					{
						THREAD *t;
						VARIABLE *v;
						pthread_mutex_lock(&thread_mutex);
						for (t = threadbase; t; t = t -> next)
						if (t -> account) //login)
						{
							PRINT(t -> account -> login);
							v = t -> cmdline.get_variable("NA$");
							if (v)
							{
								PRINT("  ");
								PRINT(v -> svalue);
							}
							v = t -> cmdline.get_variable("RO");
							if (v)
							{
								PRINT("  Room#");
								sprintf(slask,"%d",(int)v -> value);
								PRINT( slask );
							}
							PRINT("\n");
						}
						pthread_mutex_unlock(&thread_mutex);
					}
					break;
				default:
					// convert to eamon standard uppercase
					if (adjust_case)
					{
						for (i = 0; i < (int)strlen(s); i++)
							if (s[i] >= 'a' && s[i] <= 'z')
								s[i] -= 32;
					}
					return n;
				}
			} // if (crlf)
			if (crlf)
			{
				prompt_shown = 0;
				*l = 0;
				crlf = 0;
				*instr = 0;
			}
		}
	} // if (FD_ISSET(socket))
	} // if (n > 0)
	} // while (1)
	return -1;
}

int THREAD::write_text(char *s,int ll)
{
	int l = (ll == -1) ? strlen(s) : ll;
	int n;
	int i;
	int p = 0;
	int cr = 0;
	int uc = 1;
	char c;
	char buf[1024];

	strncpy(last_print, s, l);
	last_print[l] = 0;

	for (i = 0; i < l; i++)
	{
		if (s[i] == '\n')
		{
			if (!cr)
			{
				if (p < 1024)
					buf[p++] = '\r';
				if (p < 1024)
					buf[p++] = '\n';
				cr = 1;
			}
			else
			{
				cr = 0;
			}
		}
		else
		{
			c = s[i];
			if (adjust_case)
			{
			switch (c)
			{
			case '.':
//			case '\'':
			case '"':
			case '!':
			case ':':
			case '?':
			case '-':
			case '=':
			case '(':
			case ')':
				uc = 1;
				break;
			}
			if (s[i] >= 'A' && s[i] <= 'Z')
			{
				if (!uc)
					c += 32;
				uc = 0;
			}
			} // if (adjust_case)
			if (p < 1024)
				buf[p++] = c;
			cr = 0;
		}
	}
	if ( (n = write(socket, buf, p)) == -1)
	{
		perror("write() failed");
	}
	return n;
}
#endif


/*
** Turn off echoing (specific to telnet client)
*/

void	THREAD::echo_off()
{
	char	off_string[] = 
	{
		(char) IAC,
		(char) WILL,
		(char) TELOPT_ECHO,
		(char)  0,
	};

	write(socket, off_string, 3);
}


/*
** Turn on echoing (specific to telnet client)
*/


void	THREAD::echo_on()
{
	char	off_string[] = 
	{
		(char) IAC,
		(char) WONT,
		(char) TELOPT_ECHO,
		(char) TELOPT_NAOFFD,
		(char) TELOPT_NAOCRD,
		(char)  0,
	};

	write(socket, off_string, 5);
}


void THREAD::add_event(char *s)
{
	EVENT *e;
	EVENT *q;

	e = new EVENT;
	e -> next = NULL;
	e -> source = this;
	strcpy(e -> text,s);

	pthread_mutex_lock(&event_mutex);

	for (q = eventbase; q -> next; q = q -> next)
		;
	q -> next = e;

	pthread_mutex_unlock(&event_mutex);
}


int THREAD::catchup()
{
	int dirty = 0;

	if (current_event -> next)
	{
		pthread_mutex_lock(&event_mutex);

		while (current_event -> next)
		{
			current_event = current_event -> next;
			if (current_event -> source != this)
			{
				if (!dirty)
				{
					PRINT("\n");		// destroys last_print
				}
				PRINT( current_event -> text );
				dirty = 1;
			}
		}

		pthread_mutex_unlock(&event_mutex);

		if (dirty)
		{
			PRINT("\n");
			PRINT( prompt );
			PRINT( instr );
			prompt_shown = 1;
		}
	}
	return 0;
}


int THREAD::get_adv()
{
	ADV *adv;
	ADV *adv2;
	int i;
	int n;
	char slask[200];

	i = 0;
	adv2 = NULL;
	for (adv = advbase; adv; adv = adv -> next, i++)
	{
		sprintf(slask,"%4d) %s\n",adv -> num,adv -> descr);
		PRINT( slask );
		if (i >= 10 && adv -> next)
		{
			PRINT("#/Q/[M]ORE? ");
			INPUT(slask)
			else
			{
				slask[n] = 0;
				if (*slask == 'Q')
				{
					break;
				}
				else
				if (*slask >= '0' && *slask <= '9')
				{
					i = atoi(slask);
					for (adv2 = advbase; adv2; adv2 = adv2 -> next)
						if (adv2 -> num == i)
							break;
					if (adv2)
						break;
				}
			}
			i = 0;
		}
	}
	if (!adv2 && *slask != 'Q')
	{
		PRINT("Adventure #? ");
		INPUT(slask)
		else
		{
			slask[n] = 0;
			if (*slask >= '0' && *slask <= '9')
			{
				i = atoi(slask);
				for (adv2 = advbase; adv2; adv2 = adv2 -> next)
					if (adv2 -> num == i)
						break;
			}
		}
	}
	selected = adv2;
	if (adv2)
	{
		sprintf(slask,"../%s",adv2 -> dir);
		if (chdir(slask) == -1)
		{
			sprintf(slask,"cp -a %s/%s ..",
				EA_DISKS,adv2 -> dir);
			printf("Copying Adventure: %s\n",slask);
			system(slask);
		}
		else
		{
			chdir("../ea.master");
		}
	}
	return 0;
}

